// Elements.cpp : plik implementacji
//

#include "stdafx.h"
#include "Sketcher.h"
#include "Elements.h"
#include <math.h>

// CElement

CElement::CElement()
{
}

CElement::~CElement()
{
}

// Oblicza prostokt ograniczajcy element
CRect CElement::GetBoundRect()
{
   CRect BoundingRect;                 // Obiekt do przechowania prostokta ograniczajcego
   BoundingRect = m_EnclosingRect;     // Zapisz prostokt opsiujcy

   // Powiksz prostokt o szeoko pira
   BoundingRect.InflateRect(m_Pen, m_Pen);
   return BoundingRect;                // Zwr prostokt ograniczajcy
}

// Funkcje skadowe CElement

CLine::CLine(void)
{
}

CLine::~CLine(void)
{
}

// Konstruktor klasy CLine
CLine::CLine(CPoint Start, CPoint End, COLORREF aColor)
{
   m_StartPoint = Start;               // Ustawia punkt poczkowy linii
   m_EndPoint = End;                   // Ustawia punkt kocowy linii
   m_Color = aColor;                   // Ustawia kolor linii
   m_Pen = 1;                          // Ustawia szeroko pira

   // Definiuje prostokt opisujcy
   m_EnclosingRect = CRect(Start, End);
   m_EnclosingRect.NormalizeRect();
}

// Rysuj obiekt CLine
void CLine::Draw(CDC* pDC)
{
   // Tworzy piro dla tego obiektu i
   // inicjalizuje je z obiektem koloru i lini o gruboci 1 piksela
   CPen aPen;
   if(!aPen.CreatePen(PS_SOLID, m_Pen, m_Color))
   {
      // Tworzenie pira nie powiodo si.
      AfxMessageBox(_T("Tworzenie pira nie powiodo si. drawing a line"), MB_OK);
      AfxAbort();
   }

   CPen* pOldPen = pDC->SelectObject(&aPen);  // Wybierz piro

   // Teraz rysuj lini
   pDC->MoveTo(m_StartPoint);
   pDC->LineTo(m_EndPoint);

   pDC->SelectObject(pOldPen);                // Przywr stare piro
}

CRectangle::CRectangle(void)
{
}

CRectangle::~CRectangle(void)
{
}

// Konstruktor klasy CRectangle
CRectangle:: CRectangle(CPoint Start, CPoint End, COLORREF aColor)
{
   m_Color = aColor;          // Ustaw kolor prostokta
   m_Pen = 1;                 // Ustawia szeroko pira

   // Definiuje prostokt opisujcy 
   m_EnclosingRect = CRect(Start, End);
   m_EnclosingRect.NormalizeRect();
}

// Rysuj obiekt CRectangle
void CRectangle::Draw(CDC* pDC)
{
   // Tworzy piro dla tego obiektu i
   // inicjalizuje je z obiektem koloru i lini o gruboci 1 piksela
   CPen aPen;
   if(!aPen.CreatePen(PS_SOLID, m_Pen, m_Color))
   {
      // Tworzenie pira nie powiodo si.
      AfxMessageBox(_T("Tworzenie pira nie powiodo si. drawing a rectangle"), MB_OK);
      AfxAbort();
   }

   // Wybierz piro
   CPen* pOldPen = pDC->SelectObject(&aPen);
   // Select the brush
   CBrush* pOldBrush = (CBrush*)pDC->SelectStockObject(NULL_BRUSH);

   // Teraz rysuj prostokt
   pDC->Rectangle(m_EnclosingRect);

   pDC->SelectObject(pOldBrush);       // Przywr stary pdzel
   pDC->SelectObject(pOldPen);         // Przywr stare piro
}

CCircle::CCircle(void)
{
}

CCircle::~CCircle(void)
{
}

// Konstruktor obiektu okrgu
CCircle::CCircle(CPoint Start, CPoint End, COLORREF aColor)
{
   // Najpierw oblicz promie.
   // Uywamy typu zmiennoprzecinkowego, poniewa jest to wymagane
   // przez funkcj biblioteczn (w math.h) dla obliczenia pierwiastka
   long Radius = static_cast<long> (sqrt(
                  static_cast<double>((End.x-Start.x)*(End.x-Start.x)+
                                      (End.y-Start.y)*(End.y-Start.y))));

   // Teraz oblicz prostokt opisujcy okrg
   // przy zaoeniu trybu mapowania MM_TEXT
   m_EnclosingRect = CRect(Start.x-Radius, Start.y-Radius,
                           Start.x+Radius, Start.y+Radius);

   m_Color = aColor;                   // Ustaw kolor okrgu.
   m_Pen = 1;                          // Ustawia szeroko pira to 1
}

// Draw a circle
void CCircle::Draw(CDC* pDC)
{
   // Tworzy piro dla tego obiektu i
   // inicjalizuje je z obiektem koloru i lini o gruboci 1 piksela
   CPen aPen;
   if(!aPen.CreatePen(PS_SOLID, m_Pen, m_Color))
   {
      // Tworzenie pira nie powiodo si.
      AfxMessageBox(_T("Tworzenie pira nie powiodo si. drawing a circle"), MB_OK);
      AfxAbort();
   }

   CPen* pOldPen = pDC->SelectObject(&aPen);  // Wybierz piro

   // Wybierz pusty pdzel
   CBrush* pOldBrush = (CBrush*)pDC->SelectStockObject(NULL_BRUSH);

   // Teraz rysuj okrg
   pDC->Ellipse(m_EnclosingRect);

   pDC->SelectObject(pOldPen);                // Przywr stare piro
   pDC->SelectObject(pOldBrush);              // Przywr stary pdzel
}

CCurve::CCurve(void)
{
}

CCurve::~CCurve(void)
{
}

// Konstruktor obiektu krzywej
CCurve::CCurve(COLORREF aColor)
{
   m_Color = aColor;
   m_EnclosingRect = CRect(0,0,0,0);
   m_Pen = 1;
}

// Rysuj krzyw
void CCurve::Draw(CDC* pDC)
{
}
